# 500 Internal Server Error Troubleshooting Guide

## Overview

A 500 Internal Server Error indicates that something has gone wrong on the server side, but the server could not be more specific about the exact problem. This guide will help you diagnose and fix the most common causes of 500 errors in your Telegram Bot admin panel.

## Diagnostic Tools

We've created several diagnostic tools to help identify the issue:

1. **Diagnostic Script**: `check_admin_500_error.php` - A comprehensive script that checks for common issues
2. **PHP Test Script**: `test_php.php` - Tests PHP functionality and configuration
3. **PHP Info**: `phpinfo.php` - Displays detailed PHP configuration information

## Common Causes and Solutions

### 1. PHP Configuration Issues

**Symptoms:**
- 500 error occurs on all PHP pages
- PHP error logs show syntax errors or missing extensions

**Solutions:**
- Ensure PHP version is 7.2.0 or higher
- Verify required extensions are installed: pdo, pdo_mysql, mbstring, json, session
- Check PHP memory limit is sufficient (128M or higher recommended)

### 2. Database Connection Problems

**Symptoms:**
- 500 error occurs when accessing pages that require database access
- Error logs show database connection failures

**Solutions:**
- Verify database credentials in `config/config.php`
- Ensure the database server is running
- Check that the database and required tables exist
- Verify the database user has proper permissions

### 3. File Permission Issues

**Symptoms:**
- 500 error occurs when writing to logs or session data
- Error logs show permission denied errors

**Solutions:**
- Ensure the `logs` directory exists and is writable
- Check permissions on session save path
- Verify that PHP has write access to required directories

### 4. Missing or Misconfigured .htaccess

**Symptoms:**
- 500 error with message about ErrorDocument handling
- Server cannot process URL rewriting rules

**Solutions:**
- Ensure .htaccess file exists in the admin directory
- Verify that mod_rewrite is enabled on the server
- Check that ErrorDocument directives are correctly configured
- Make sure RewriteBase is set correctly

### 5. PHP Function Errors

**Symptoms:**
- 500 error when calling specific functions
- Error logs show undefined function errors

**Solutions:**
- Verify that all required functions are defined
- Check that the `logError` function exists and is properly implemented
- Ensure all required files are being included correctly

### 6. Session Handling Issues

**Symptoms:**
- 500 error when accessing admin panel after login
- Session data not being stored or retrieved correctly

**Solutions:**
- Check that SESSION_LIFETIME is defined in config.php
- Verify session save path is writable
- Ensure admin_sessions table exists in the database

## Step-by-Step Troubleshooting

1. **Check Server Error Logs**
   - Look for specific error messages in the server's error log
   - PHP errors are typically logged in the server's error log or in your custom log files

2. **Enable Detailed Error Reporting**
   - Temporarily modify `config/config.php` to show detailed errors:
     ```php
     error_reporting(E_ALL);
     ini_set('display_errors', 1);
     ```

3. **Run Diagnostic Tools**
   - Access `check_admin_500_error.php` in your browser
   - Review the results and fix any issues identified

4. **Check File Permissions**
   - Ensure `logs` directory exists and has write permissions
   - Verify permissions on all directories that need to be writable

5. **Verify Database Connection**
   - Test database connection using `test_php.php`
   - Check that all required tables exist

6. **Review .htaccess Configuration**
   - Ensure .htaccess file is properly configured
   - Add ErrorDocument directive for 500 errors

7. **Check for Syntax Errors**
   - Review recent code changes for syntax errors
   - Use a linter to check PHP files for errors

## Preventive Measures

1. **Implement Proper Error Handling**
   - Use try-catch blocks for error-prone operations
   - Log errors with context for easier debugging

2. **Regular Backups**
   - Keep backups of working configurations
   - Back up database regularly

3. **Testing Environment**
   - Test changes in a development environment before deploying to production
   - Implement a staging environment for testing

4. **Monitoring**
   - Set up monitoring for server health and errors
   - Configure alerts for critical errors

## Additional Resources

- [PHP Error Handling Documentation](https://www.php.net/manual/en/book.errorfunc.php)
- [Apache .htaccess Guide](https://httpd.apache.org/docs/current/howto/htaccess.html)
- [MySQL Troubleshooting](https://dev.mysql.com/doc/refman/8.0/en/troubleshooting.html)