# Contributing to Telegram Bot with Admin Panel

Thank you for considering contributing to this project! This document provides guidelines and instructions for contributing.

## Code of Conduct

By participating in this project, you agree to maintain a respectful and inclusive environment for everyone. Please be considerate of differing viewpoints and experiences, and focus on what is best for the community and the project.

## How Can I Contribute?

### Reporting Bugs

Bugs are tracked as GitHub issues. Before creating a bug report, please check if the issue has already been reported. When you create a bug report, include as many details as possible:

- **Use a clear and descriptive title**
- **Describe the exact steps to reproduce the bug**
- **Provide specific examples** (e.g., sample code or configuration)
- **Describe the behavior you observed and what you expected to see**
- **Include screenshots or animated GIFs** if applicable
- **Include details about your environment** (OS, PHP version, MySQL version, etc.)

### Suggesting Enhancements

Enhancement suggestions are also tracked as GitHub issues. When creating an enhancement suggestion, include:

- **Use a clear and descriptive title**
- **Provide a detailed description of the proposed enhancement**
- **Explain why this enhancement would be useful**
- **Include any relevant examples or mockups**

### Pull Requests

1. **Fork the repository**
2. **Create a branch** for your feature or bugfix (`git checkout -b feature/amazing-feature`)
3. **Commit your changes** with clear commit messages
4. **Push to your branch** (`git push origin feature/amazing-feature`)
5. **Open a Pull Request**

## Development Setup

### Prerequisites

- PHP 7.4 or higher
- MySQL 5.7 or higher
- Composer (for dependency management)
- Git

### Local Development Environment

1. **Clone your fork**
   ```
   git clone https://github.com/your-username/telegram-bot-admin.git
   cd telegram-bot-admin
   ```

2. **Set up the database**
   - Create a new MySQL database
   - Import the schema from `database/schema.sql`

3. **Configure the bot**
   - Copy `config/config.sample.php` to `config/config.php`
   - Update the configuration with your database credentials and bot token

4. **Set up a local web server**
   - You can use PHP's built-in server for development:
     ```
     php -S localhost:8000
     ```

5. **Testing the webhook**
   - For local development, you can use tools like ngrok to expose your local server
   - Set up the webhook using the Telegram API or the admin panel

## Coding Standards

### PHP Code Style

- Follow PSR-12 coding standards
- Use meaningful variable and function names
- Add comments for complex logic
- Keep functions focused on a single responsibility

### JavaScript Code Style

- Use ES6 syntax where appropriate
- Follow consistent indentation (2 spaces)
- Use meaningful variable and function names
- Add comments for complex logic

### Documentation

- Update documentation when changing functionality
- Document all public methods and functions
- Keep the README and other documentation files up to date

## Testing

### Manual Testing

Before submitting a pull request, manually test your changes:

1. Test the affected functionality in the bot
2. Test the affected functionality in the admin panel
3. Test on different devices and browsers (for admin panel)

### Automated Testing

If you're adding new features, consider adding appropriate tests:

1. Unit tests for individual functions
2. Integration tests for complex workflows

## Git Workflow

### Branching Strategy

- `main` branch contains the stable version
- `develop` branch is for ongoing development
- Feature branches should be created from `develop`
- Hotfix branches should be created from `main`

### Commit Messages

Write clear, concise commit messages that explain the changes made:

```
type(scope): Short description

Longer description if necessary
```

Types include:
- `feat`: New feature
- `fix`: Bug fix
- `docs`: Documentation changes
- `style`: Code style changes (formatting, etc.)
- `refactor`: Code refactoring
- `test`: Adding or updating tests
- `chore`: Maintenance tasks

## Release Process

1. Update the version number in relevant files
2. Update the CHANGELOG.md with the changes
3. Create a new release on GitHub
4. Tag the release with the version number

## Additional Resources

- [Telegram Bot API Documentation](https://core.telegram.org/bots/api)
- [PHP Documentation](https://www.php.net/docs.php)
- [MySQL Documentation](https://dev.mysql.com/doc/)
- [Bootstrap Documentation](https://getbootstrap.com/docs/)

## Questions?

If you have any questions about contributing, please open an issue or contact the maintainers.

Thank you for contributing to make this project better!