# Installation Guide for Telegram Bot with Admin Panel

## Prerequisites

- PHP 7.4 or higher
- MySQL 5.7 or higher
- Web server (Apache/Nginx)
- SSL certificate (required for Telegram webhooks)
- Telegram Bot Token (create one via [@BotFather](https://t.me/BotFather))

## Step 1: Server Setup

1. Ensure your web server has PHP installed with the following extensions:
   - PDO and PDO_MySQL
   - cURL
   - mbstring
   - JSON

2. Make sure your web server is accessible via HTTPS (required for Telegram webhooks)

## Step 2: Database Setup

1. Create a new MySQL database for the bot
2. Note down the database name, username, and password

## Step 3: Bot Configuration

1. Edit the `config/config.php` file with your database credentials and Telegram Bot Token:

```php
// Database configuration
define('DB_HOST', 'localhost');     // Your database host
define('DB_NAME', 'your_db_name');  // Your database name
define('DB_USER', 'your_db_user');  // Your database username
define('DB_PASS', 'your_db_pass');  // Your database password

// Bot configuration
define('BOT_TOKEN', 'your_bot_token');  // Your Telegram Bot Token
define('BOT_USERNAME', 'your_bot_username');  // Your bot username without @

// Admin configuration
define('ADMIN_SESSION_DURATION', 3600);  // Admin session duration in seconds (default: 1 hour)
```

## Step 4: Initialize the Database

Run the database initialization script to create all necessary tables:

```bash
php database/init_db.php
```

Alternatively, you can manually import the SQL schema:

```bash
mysql -u your_db_user -p your_db_name < database/schema.sql
```

## Step 5: Set Up the Webhook

You have two options to set up the webhook:

### Option 1: Using the Admin Panel

1. Access the admin panel at `https://your-domain.com/path/to/admin/`
2. Log in with the default credentials:
   - Username: `admin`
   - Password: `admin123`
3. Go to the Settings page
4. Enter your webhook URL (e.g., `https://your-domain.com/path/to/webhook.php`)
5. Click "Set Webhook"

### Option 2: Using the Telegram API Directly

Make a request to the Telegram API:

```
https://api.telegram.org/bot<YOUR_BOT_TOKEN>/setWebhook?url=https://your-domain.com/path/to/webhook.php
```

Replace `<YOUR_BOT_TOKEN>` with your actual bot token and the URL with your webhook URL.

## Step 6: Directory Permissions

Ensure the following directories are writable by the web server:

```bash
chmod -R 755 logs/
```

## Step 7: Test the Bot

1. Open Telegram and search for your bot by username
2. Start a conversation with your bot by sending `/start`
3. The bot should respond with the welcome message

## Step 8: Customize the Bot

1. Log in to the admin panel
2. Change the default admin password immediately
3. Configure bot settings (welcome message, help message, etc.)
4. Create menus, submenus, content, and links

## Troubleshooting

### Webhook Issues

- Ensure your server has a valid SSL certificate
- Check that the webhook URL is correct and accessible
- Verify that the `webhook.php` file has the correct permissions
- Check the logs in the `logs/` directory for errors

### Database Connection Issues

- Verify your database credentials in `config/config.php`
- Ensure the database user has the necessary permissions
- Check if the database server is running

### Bot Not Responding

- Verify that the bot token is correct
- Check if the webhook is set correctly
- Look for errors in the logs

## Security Recommendations

1. Change the default admin password immediately
2. Use strong passwords for both the admin panel and database
3. Consider implementing IP restrictions for the admin panel
4. Regularly backup your database
5. Keep PHP and all extensions updated

## Support

If you encounter any issues or have questions, please open an issue on the GitHub repository or contact the maintainer.