# Quick Start Guide for Telegram Bot

## Configuration Complete

Your Telegram bot has been configured with the following settings:

- **Bot Username**: @tatkal_father_bot
- **Webhook URL**: https://forexbot.co.in/new_bot/webhook.php
- **Database**: mbofzzfa_new_bot_db
- **Admin Panel URL**: https://forexbot.co.in/new_bot/admin/

## Admin Panel Access Issue Fixed

We've detected and fixed a 404 Not Found error with the admin panel. The following files have been added to ensure proper access:

- `.htaccess` in the admin directory for proper URL routing
- `index.html` in the admin directory for proper redirection
- `check_admin_panel.php` to diagnose admin panel accessibility
- `fix_admin_tables.php` to ensure all required database tables exist
- `check_database.php` to verify database connection and tables
- `create_admin_structure.php` to create necessary admin panel directories
- `fix_admin_panel.bat` to run all fix scripts in sequence

## Next Steps

### 1. Verify Configuration

Run the verification script to check if your configuration is correct:

```bash
php verify_config.php
```

This will check your bot token, database connection, and webhook URL.

### 2. Initialize Database

If you haven't already, initialize the database with the required tables:

```bash
php database/init_db.php
```

### 3. Set Webhook

Set up the webhook to receive updates from Telegram:

```bash
php set_webhook.php
```

### 4. Set Bot Commands

Configure the commands that will be shown in the Telegram interface:

```bash
php set_commands.php
```

### 5. Check Bot Status

Verify that your bot is working correctly:

```bash
php check_bot.php
```

### 6. Fix and Access Admin Panel

If you encounter a 404 Not Found error when accessing the admin panel, run the fix script:

```bash
# On Windows
fix_admin_panel.bat

# On Linux/Mac
php check_database.php
php check_admin_panel.php
php fix_admin_tables.php
php create_admin_structure.php
```

Then access the admin panel at: https://forexbot.co.in/new_bot/admin/

Default login credentials:
- **Username**: admin
- **Password**: admin123

**Important**: Change the default password immediately after logging in!

### 7. Update Admin Telegram ID

Update your Telegram user ID in the config file to gain admin privileges in the bot:

1. Open `config/config.php`
2. Find the line with `define('ADMIN_IDS', [123456789]);`
3. Replace `123456789` with your actual Telegram user ID

You can get your Telegram ID by sending a message to @userinfobot on Telegram.

## Troubleshooting

If you encounter any issues:

1. Check the logs in the `logs` directory
2. Verify your database credentials
3. Make sure your webhook URL is publicly accessible
4. Ensure your bot token is correct

For more detailed information, refer to the following documentation:

- INSTALLATION.md - Detailed installation instructions
- TROUBLESHOOTING.md - Common issues and solutions
- DEVELOPER_GUIDE.md - Information for developers
- API_DOCUMENTATION.md - API documentation