# Telegram Bot with Admin Panel

A comprehensive Telegram bot with an admin panel for managing menus, submenus, content, user management, and broadcasting messages.

## Features

- **Menu & Submenu Structure**: Hierarchical navigation system
- **Content Management**: Add, edit, and delete content
- **Link Management**: Website, download, and WhatsApp links
- **User Management**: View, block/unblock users, and send individual messages
- **Broadcasting**: Send messages to all users at once
- **Admin Panel**: Clean, modern, and responsive design

## Requirements

- PHP 7.4 or higher
- MySQL 5.7 or higher
- Web server (Apache/Nginx)
- SSL certificate (required for Telegram webhooks)
- Telegram Bot Token

## Installation

1. **Clone the repository**

```bash
git clone https://github.com/yourusername/telegram-bot-admin.git
cd telegram-bot-admin
```

2. **Configure the bot**

Edit the `config/config.php` file with your database credentials and Telegram Bot Token:

```php
// Database configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'your_database_name');
define('DB_USER', 'your_database_user');
define('DB_PASS', 'your_database_password');

// Bot configuration
define('BOT_TOKEN', 'your_telegram_bot_token');
define('BOT_USERNAME', 'your_bot_username');
```

3. **Initialize the database**

Run the database initialization script:

```bash
php database/init_db.php
```

4. **Set up the webhook**

Set up the webhook URL in the Telegram API. Your webhook URL should point to the `webhook.php` file on your server.

You can set the webhook using the admin panel's settings page or manually using the Telegram Bot API:

```
https://api.telegram.org/bot<YOUR_BOT_TOKEN>/setWebhook?url=https://your-domain.com/path/to/webhook.php
```

5. **Access the admin panel**

Open your web browser and navigate to the admin panel:

```
https://your-domain.com/path/to/admin/
```

Default login credentials:
- Username: `admin`
- Password: `admin123`

**Important**: Change the default password immediately after your first login!

## Directory Structure

```
├── admin/                  # Admin panel files
│   ├── includes/           # Admin panel includes
│   ├── index.php           # Admin dashboard
│   ├── login.php           # Admin login
│   ├── menus.php           # Menu management
│   └── ...                 # Other admin pages
├── assets/                 # CSS, JS, and images
│   ├── css/                # CSS files
│   ├── js/                 # JavaScript files
│   └── img/                # Image files
├── classes/                # PHP classes
│   └── TelegramBot.php     # Telegram Bot class
├── config/                 # Configuration files
│   └── config.php          # Main configuration
├── database/               # Database files
│   ├── schema.sql          # Database schema
│   └── init_db.php         # Database initialization
├── includes/               # Include files
│   └── database.php        # Database connection
├── logs/                   # Log files
└── webhook.php             # Telegram webhook handler
```

## Usage

### Admin Panel

1. **Dashboard**: Overview of user count, active sessions, and recent broadcasts
2. **Menu Management**: Add, edit, or delete menus
3. **Submenu Management**: Add, edit, or delete submenus
4. **Content Management**: Add, edit, or delete content
5. **Link Management**: Add, edit, or delete links
6. **User Management**: View, block/unblock users, and send individual messages
7. **Broadcasting**: Send messages to all users at once
8. **Settings**: Configure bot settings and webhook

### Telegram Bot

Users can interact with the bot using the menu buttons to navigate through the menu structure and access content and links.

## Security

- All admin passwords are hashed using PHP's password_hash() function
- Session management with secure tokens
- Input validation and sanitization
- Protection against SQL injection

## License

This project is licensed under the MIT License - see the LICENSE file for details.

## Support

For support, please open an issue on the GitHub repository or contact the maintainer.