# Telegram Bot Admin Panel

## Overview

This directory contains the admin panel for managing your Telegram bot. The admin panel provides a web interface to:

- View bot statistics and user activity
- Manage menus and submenus
- Create and edit content
- Send broadcast messages to users
- Configure bot settings

## Files and Structure

- `index.php` - Dashboard with statistics and recent activity
- `login.php` - Admin login page
- `auth.php` - Authentication handler
- `menus.php` - Menu management
- `submenus.php` - Submenu management
- `content.php` - Content management
- `broadcast.php` - Send messages to users
- `settings.php` - Bot configuration
- `users.php` - User management
- `logout.php` - Logout handler
- `includes/` - Common includes and templates

## Access

Access the admin panel at: https://forexbot.co.in/new_bot/admin/

Default login credentials:
- Username: admin
- Password: admin123

**Important**: Change the default password immediately after logging in!

## Troubleshooting

If you encounter a 404 Not Found error when accessing the admin panel, run the fix script:

```bash
php ../fix_admin_tables.php
```

This will ensure all required database tables exist.

## Security

The admin panel includes several security features:

- Session-based authentication
- Password hashing
- CSRF protection
- Session expiration
- IP and user agent tracking

For additional security, consider:

1. Changing the default admin username and password
2. Enabling HTTPS
3. Implementing two-factor authentication
4. Restricting access by IP address