<?php
/**
 * Error page for 500 Internal Server Error
 */

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Set content type to HTML
header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>500 Internal Server Error</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            margin: 20px;
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        h1 {
            color: #d32f2f;
        }
        .error-box {
            background-color: #ffebee;
            border-left: 5px solid #d32f2f;
            padding: 15px;
            margin-bottom: 20px;
        }
        .info-box {
            background-color: #e3f2fd;
            border-left: 5px solid #2196f3;
            padding: 15px;
            margin-bottom: 20px;
        }
        pre {
            background-color: #f5f5f5;
            padding: 10px;
            border-radius: 5px;
            overflow-x: auto;
        }
        .button {
            display: inline-block;
            background-color: #2196f3;
            color: white;
            padding: 10px 15px;
            text-decoration: none;
            border-radius: 4px;
            margin-top: 20px;
        }
        .button:hover {
            background-color: #0b7dda;
        }
    </style>
</head>
<body>
    <h1>500 Internal Server Error</h1>
    
    <div class="error-box">
        <p>The server encountered an internal error and was unable to complete your request.</p>
        <p>Please try the following:</p>
        <ul>
            <li>Refresh the page</li>
            <li>Clear your browser cache</li>
            <li>Try again later</li>
        </ul>
    </div>
    
    <div class="info-box">
        <p>If you are the administrator, please check the following:</p>
        <ul>
            <li>PHP error logs</li>
            <li>Database connection</li>
            <li>File permissions</li>
            <li>Run the diagnostic script: <a href="../check_admin_500_error.php">Diagnostic Tool</a></li>
        </ul>
    </div>
    
    <a href="../index.php" class="button">Go to Homepage</a>
    <a href="login.php" class="button">Go to Login</a>
</body>
</html>