<?php
/**
 * Admin Dashboard
 */

// Include authentication
require_once 'auth.php';

// Get dashboard statistics
try {
    // Total users count
    $stmt = $db->query("SELECT COUNT(*) as total FROM users");
    $totalUsers = $stmt->fetch()['total'];
    
    // Active users in last 24 hours
    $stmt = $db->query("SELECT COUNT(*) as active FROM users WHERE last_activity > DATE_SUB(NOW(), INTERVAL 24 HOUR)");
    $activeUsers = $stmt->fetch()['active'];
    
    // Total menus
    $stmt = $db->query("SELECT COUNT(*) as total FROM menus");
    $totalMenus = $stmt->fetch()['total'];
    
    // Total submenus
    $stmt = $db->query("SELECT COUNT(*) as total FROM submenus");
    $totalSubmenus = $stmt->fetch()['total'];
    
    // Recent broadcasts
    $stmt = $db->query("SELECT * FROM broadcasts ORDER BY created_at DESC LIMIT 5");
    $recentBroadcasts = $stmt->fetchAll();
    
    // Recent user activity
    $stmt = $db->query("SELECT a.*, u.username, u.first_name, u.last_name 
                        FROM activity_logs a 
                        LEFT JOIN users u ON a.user_id = u.id 
                        WHERE a.type = 'user' 
                        ORDER BY a.created_at DESC LIMIT 10");
    $recentActivity = $stmt->fetchAll();
    
} catch (Exception $e) {
    logError("Dashboard error: " . $e->getMessage());
    $error = "Error loading dashboard data. Please check the error logs.";
}

// Page title
$pageTitle = "Dashboard";

// Include header
include 'includes/header.php';
?>

<div class="container-fluid py-4">
    <h1 class="h3 mb-4">Dashboard</h1>
    
    <?php if (isset($error)): ?>
        <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>
    
    <!-- Stats Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Users</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo number_format($totalUsers ?? 0); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-users fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Active Users (24h)</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo number_format($activeUsers ?? 0); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-user-clock fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Total Menus</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo number_format($totalMenus ?? 0); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-list fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Total Submenus</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo number_format($totalSubmenus ?? 0); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-sitemap fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Content Row -->
    <div class="row">
        <!-- Recent Broadcasts -->
        <div class="col-lg-6 mb-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">Recent Broadcasts</h6>
                    <a href="broadcast.php" class="btn btn-sm btn-primary">New Broadcast</a>
                </div>
                <div class="card-body">
                    <?php if (empty($recentBroadcasts)): ?>
                        <p class="text-center text-muted">No broadcasts found</p>
                    <?php else: ?>
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Message</th>
                                        <th>Sent</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($recentBroadcasts as $broadcast): ?>
                                        <tr>
                                            <td><?php echo date('M d, H:i', strtotime($broadcast['created_at'])); ?></td>
                                            <td><?php echo htmlspecialchars(mb_substr($broadcast['message'], 0, 30)) . (mb_strlen($broadcast['message']) > 30 ? '...' : ''); ?></td>
                                            <td><?php echo number_format($broadcast['sent_count']); ?>/<?php echo number_format($broadcast['total_count']); ?></td>
                                            <td>
                                                <?php if ($broadcast['status'] === 'completed'): ?>
                                                    <span class="badge bg-success">Completed</span>
                                                <?php elseif ($broadcast['status'] === 'in_progress'): ?>
                                                    <span class="badge bg-warning">In Progress</span>
                                                <?php else: ?>
                                                    <span class="badge bg-secondary"><?php echo ucfirst($broadcast['status']); ?></span>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Recent Activity -->
        <div class="col-lg-6 mb-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Recent User Activity</h6>
                </div>
                <div class="card-body">
                    <?php if (empty($recentActivity)): ?>
                        <p class="text-center text-muted">No recent activity</p>
                    <?php else: ?>
                        <div class="activity-feed">
                            <?php foreach ($recentActivity as $activity): ?>
                                <div class="activity-item">
                                    <div class="activity-content">
                                        <small class="text-muted float-end"><?php echo date('M d, H:i', strtotime($activity['created_at'])); ?></small>
                                        <strong><?php echo htmlspecialchars($activity['first_name'] . ' ' . $activity['last_name']); ?></strong>
                                        <span class="text-muted">@<?php echo htmlspecialchars($activity['username']); ?></span>
                                        <p class="mb-2"><?php echo htmlspecialchars($activity['action']); ?></p>
                                    </div>
                                </div>
                                <hr>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
// Include footer
include 'includes/footer.php';
?>