<?php
/**
 * Admin Logout
 */

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Include required files
require_once dirname(__DIR__) . '/config/config.php';
require_once dirname(__DIR__) . '/includes/database.php';

// Check if user is logged in
if (isset($_SESSION['admin_id']) && isset($_SESSION['admin_token'])) {
    try {
        // Delete session from database
        $stmt = $db->prepare("DELETE FROM admin_sessions WHERE admin_id = ? AND session_token = ?");
        $stmt->execute([$_SESSION['admin_id'], $_SESSION['admin_token']]);
        
        // Log activity
        logActivity('admin', null, $_SESSION['admin_id'], 'logout', 'Admin logout', $_SERVER['REMOTE_ADDR']);
    } catch (Exception $e) {
        logError("Logout error: " . $e->getMessage());
    }
}

// Destroy session
session_unset();
session_destroy();

// Redirect to login page
header('Location: login.php');
exit;