/**
 * Content Management JavaScript
 */
document.addEventListener('DOMContentLoaded', function() {
    // Edit content button click
    document.querySelectorAll('.edit-content').forEach(function(button) {
        button.addEventListener('click', function() {
            const id = this.getAttribute('data-id');
            const submenuId = this.getAttribute('data-submenu-id');
            const title = this.getAttribute('data-title');
            const content = this.getAttribute('data-content');
            const order = this.getAttribute('data-order');
            const status = this.getAttribute('data-status');
            
            document.getElementById('edit-id').value = id;
            document.getElementById('edit-submenu-id').value = submenuId;
            document.getElementById('edit-title').value = title;
            document.getElementById('edit-content').value = content;
            document.getElementById('edit-order').value = order;
            document.getElementById('edit-status').value = status;
        });
    });
    
    // Delete content button click
    document.querySelectorAll('.delete-content').forEach(function(button) {
        button.addEventListener('click', function() {
            const id = this.getAttribute('data-id');
            const title = this.getAttribute('data-title');
            
            document.getElementById('delete-id').value = id;
            document.getElementById('delete-content-title').textContent = title;
        });
    });
    
    // View content button click
    document.querySelectorAll('.view-content').forEach(function(button) {
        button.addEventListener('click', function() {
            const title = this.getAttribute('data-title');
            const content = this.getAttribute('data-content');
            
            document.getElementById('view-content-title').textContent = title;
            document.getElementById('view-content-body').textContent = content;
        });
    });
    
    // Form validation for add content
    const addContentForm = document.querySelector('#addContentModal form');
    if (addContentForm) {
        addContentForm.addEventListener('submit', function(event) {
            const submenuId = document.getElementById('submenu_id').value;
            const title = document.getElementById('title').value.trim();
            
            if (!submenuId || !title) {
                event.preventDefault();
                alert('Please select a submenu and enter a title.');
            }
        });
    }
    
    // Form validation for edit content
    const editContentForm = document.querySelector('#editContentModal form');
    if (editContentForm) {
        editContentForm.addEventListener('submit', function(event) {
            const submenuId = document.getElementById('edit-submenu-id').value;
            const title = document.getElementById('edit-title').value.trim();
            
            if (!submenuId || !title) {
                event.preventDefault();
                alert('Please select a submenu and enter a title.');
            }
        });
    }
});