/**
 * Links Management JavaScript
 */
document.addEventListener('DOMContentLoaded', function() {
    // Edit link button click
    document.querySelectorAll('.edit-link').forEach(function(button) {
        button.addEventListener('click', function() {
            const id = this.getAttribute('data-id');
            const submenuId = this.getAttribute('data-submenu-id');
            const title = this.getAttribute('data-title');
            const url = this.getAttribute('data-url');
            const type = this.getAttribute('data-type');
            const order = this.getAttribute('data-order');
            const status = this.getAttribute('data-status');
            
            document.getElementById('edit-id').value = id;
            document.getElementById('edit-submenu-id').value = submenuId;
            document.getElementById('edit-title').value = title;
            document.getElementById('edit-url').value = url;
            document.getElementById('edit-type').value = type;
            document.getElementById('edit-order').value = order;
            document.getElementById('edit-status').value = status;
        });
    });
    
    // Delete link button click
    document.querySelectorAll('.delete-link').forEach(function(button) {
        button.addEventListener('click', function() {
            const id = this.getAttribute('data-id');
            const title = this.getAttribute('data-title');
            
            document.getElementById('delete-id').value = id;
            document.getElementById('delete-link-title').textContent = title;
        });
    });
    
    // Form validation for add link
    const addLinkForm = document.querySelector('#addLinkModal form');
    if (addLinkForm) {
        addLinkForm.addEventListener('submit', function(event) {
            const submenuId = document.getElementById('submenu_id').value;
            const title = document.getElementById('title').value.trim();
            const url = document.getElementById('url').value.trim();
            
            if (!submenuId || !title || !url) {
                event.preventDefault();
                alert('Please select a submenu, enter a title and URL.');
            }
            
            // Validate WhatsApp URL format if type is whatsapp
            const type = document.getElementById('type').value;
            if (type === 'whatsapp' && !url.startsWith('https://wa.me/')) {
                event.preventDefault();
                alert('WhatsApp links should use the format: https://wa.me/1234567890');
            }
        });
    }
    
    // Form validation for edit link
    const editLinkForm = document.querySelector('#editLinkModal form');
    if (editLinkForm) {
        editLinkForm.addEventListener('submit', function(event) {
            const submenuId = document.getElementById('edit-submenu-id').value;
            const title = document.getElementById('edit-title').value.trim();
            const url = document.getElementById('edit-url').value.trim();
            
            if (!submenuId || !title || !url) {
                event.preventDefault();
                alert('Please select a submenu, enter a title and URL.');
            }
            
            // Validate WhatsApp URL format if type is whatsapp
            const type = document.getElementById('edit-type').value;
            if (type === 'whatsapp' && !url.startsWith('https://wa.me/')) {
                event.preventDefault();
                alert('WhatsApp links should use the format: https://wa.me/1234567890');
            }
        });
    }
    
    // Update URL format hint when type changes
    const typeSelect = document.getElementById('type');
    if (typeSelect) {
        typeSelect.addEventListener('change', function() {
            updateUrlHint(this.value, false);
        });
    }
    
    const editTypeSelect = document.getElementById('edit-type');
    if (editTypeSelect) {
        editTypeSelect.addEventListener('change', function() {
            updateUrlHint(this.value, true);
        });
    }
    
    // Function to update URL hint based on selected type
    function updateUrlHint(type, isEdit) {
        const prefix = isEdit ? 'edit-' : '';
        const urlField = document.getElementById(prefix + 'url');
        const hintElement = urlField.nextElementSibling;
        
        if (type === 'whatsapp') {
            hintElement.textContent = 'For WhatsApp links, use format: https://wa.me/1234567890';
        } else if (type === 'download') {
            hintElement.textContent = 'Direct link to downloadable file';
        } else {
            hintElement.textContent = 'Enter the full URL including http:// or https://';
        }
    }
});