/**
 * Menu Management JavaScript
 */

$(document).ready(function() {
    // Handle edit menu button click
    $('.edit-menu').on('click', function() {
        const id = $(this).data('id');
        const title = $(this).data('title');
        const order = $(this).data('order');
        const status = $(this).data('status');
        
        // Populate edit form
        $('#edit-id').val(id);
        $('#edit-title').val(title);
        $('#edit-order').val(order);
        $('#edit-status').val(status);
    });
    
    // Handle delete menu button click
    $('.delete-menu').on('click', function() {
        const id = $(this).data('id');
        const title = $(this).data('title');
        
        // Populate delete form
        $('#delete-id').val(id);
        $('#delete-menu-title').text(title);
    });
    
    // Form validation
    $('form').on('submit', function(e) {
        const action = $(this).find('input[name="action"]').val();
        
        if (action === 'add' || action === 'edit') {
            const title = $(this).find('input[name="title"]').val().trim();
            
            if (!title) {
                e.preventDefault();
                alert('Menu title is required.');
                return false;
            }
        }
        
        return true;
    });
});