/**
 * Settings page JavaScript
 */

document.addEventListener('DOMContentLoaded', function() {
    // Handle delete webhook button
    const deleteWebhookBtn = document.getElementById('deleteWebhookBtn');
    const deleteWebhookForm = document.getElementById('deleteWebhookForm');
    
    if (deleteWebhookBtn && deleteWebhookForm) {
        deleteWebhookBtn.addEventListener('click', function() {
            if (confirm('Are you sure you want to delete the webhook?')) {
                deleteWebhookForm.submit();
            }
        });
    }
    
    // Handle webhook form submission
    const webhookForm = document.getElementById('webhookForm');
    if (webhookForm) {
        webhookForm.addEventListener('submit', function(e) {
            const webhookUrl = document.getElementById('webhook_url').value.trim();
            
            // Basic URL validation
            if (!webhookUrl.startsWith('https://')) {
                e.preventDefault();
                alert('Webhook URL must start with https://');
                return false;
            }
            
            return true;
        });
    }
    
    // Toggle maintenance message textarea based on maintenance mode checkbox
    const maintenanceMode = document.getElementById('maintenance_mode');
    const maintenanceMessageGroup = document.getElementById('maintenance_message').closest('.mb-3');
    
    if (maintenanceMode && maintenanceMessageGroup) {
        // Initial state
        maintenanceMessageGroup.style.display = maintenanceMode.checked ? 'block' : 'none';
        
        // Toggle on change
        maintenanceMode.addEventListener('change', function() {
            maintenanceMessageGroup.style.display = this.checked ? 'block' : 'none';
        });
    }
    
    // Format helper buttons for message textareas
    const textareas = document.querySelectorAll('textarea');
    textareas.forEach(function(textarea) {
        // Create format buttons container
        const formatButtonsContainer = document.createElement('div');
        formatButtonsContainer.className = 'btn-group btn-group-sm mb-2';
        formatButtonsContainer.setAttribute('role', 'group');
        formatButtonsContainer.setAttribute('aria-label', 'Formatting options');
        
        // Bold button
        const boldBtn = document.createElement('button');
        boldBtn.type = 'button';
        boldBtn.className = 'btn btn-outline-secondary';
        boldBtn.innerHTML = '<i class="fas fa-bold"></i>';
        boldBtn.title = 'Bold';
        boldBtn.addEventListener('click', function(e) {
            e.preventDefault();
            insertFormatting(textarea, '<b>', '</b>');
        });
        
        // Italic button
        const italicBtn = document.createElement('button');
        italicBtn.type = 'button';
        italicBtn.className = 'btn btn-outline-secondary';
        italicBtn.innerHTML = '<i class="fas fa-italic"></i>';
        italicBtn.title = 'Italic';
        italicBtn.addEventListener('click', function(e) {
            e.preventDefault();
            insertFormatting(textarea, '<i>', '</i>');
        });
        
        // Code button
        const codeBtn = document.createElement('button');
        codeBtn.type = 'button';
        codeBtn.className = 'btn btn-outline-secondary';
        codeBtn.innerHTML = '<i class="fas fa-code"></i>';
        codeBtn.title = 'Code';
        codeBtn.addEventListener('click', function(e) {
            e.preventDefault();
            insertFormatting(textarea, '<code>', '</code>');
        });
        
        // Link button
        const linkBtn = document.createElement('button');
        linkBtn.type = 'button';
        linkBtn.className = 'btn btn-outline-secondary';
        linkBtn.innerHTML = '<i class="fas fa-link"></i>';
        linkBtn.title = 'Link';
        linkBtn.addEventListener('click', function(e) {
            e.preventDefault();
            const url = prompt('Enter URL:', 'https://');
            if (url) {
                const text = prompt('Enter link text:', 'Link text');
                if (text) {
                    insertText(textarea, `<a href="${url}">${text}</a>`);
                }
            }
        });
        
        // Add buttons to container
        formatButtonsContainer.appendChild(boldBtn);
        formatButtonsContainer.appendChild(italicBtn);
        formatButtonsContainer.appendChild(codeBtn);
        formatButtonsContainer.appendChild(linkBtn);
        
        // Insert container before textarea
        textarea.parentNode.insertBefore(formatButtonsContainer, textarea);
    });
    
    // Helper function to insert formatting tags
    function insertFormatting(textarea, openTag, closeTag) {
        const start = textarea.selectionStart;
        const end = textarea.selectionEnd;
        const selectedText = textarea.value.substring(start, end);
        const replacement = openTag + selectedText + closeTag;
        
        textarea.value = textarea.value.substring(0, start) + 
                         replacement + 
                         textarea.value.substring(end);
        
        // Set cursor position after insertion
        textarea.focus();
        if (selectedText.length > 0) {
            textarea.selectionStart = start + replacement.length;
            textarea.selectionEnd = start + replacement.length;
        } else {
            textarea.selectionStart = start + openTag.length;
            textarea.selectionEnd = start + openTag.length;
        }
    }
    
    // Helper function to insert text at cursor position
    function insertText(textarea, text) {
        const start = textarea.selectionStart;
        textarea.value = textarea.value.substring(0, start) + 
                       text + 
                       textarea.value.substring(start);
        
        // Set cursor position after insertion
        textarea.focus();
        textarea.selectionStart = start + text.length;
        textarea.selectionEnd = start + text.length;
    }
});