/**
 * Submenu Management JavaScript
 */

$(document).ready(function() {
    // Handle edit submenu button click
    $('.edit-submenu').on('click', function() {
        const id = $(this).data('id');
        const menuId = $(this).data('menu-id');
        const title = $(this).data('title');
        const order = $(this).data('order');
        const status = $(this).data('status');
        const contentType = $(this).data('content-type');
        
        // Populate edit form
        $('#edit-id').val(id);
        $('#edit-menu-id').val(menuId);
        $('#edit-title').val(title);
        $('#edit-order').val(order);
        $('#edit-status').val(status);
        $('#edit-content-type').val(contentType);
    });
    
    // Handle delete submenu button click
    $('.delete-submenu').on('click', function() {
        const id = $(this).data('id');
        const title = $(this).data('title');
        
        // Populate delete form
        $('#delete-id').val(id);
        $('#delete-submenu-title').text(title);
    });
    
    // Form validation
    $('form').on('submit', function(e) {
        const action = $(this).find('input[name="action"]').val();
        
        if (action === 'add' || action === 'edit') {
            const title = $(this).find('input[name="title"]').val().trim();
            const menuId = $(this).find('select[name="menu_id"]').val();
            
            if (!title) {
                e.preventDefault();
                alert('Submenu title is required.');
                return false;
            }
            
            if (!menuId) {
                e.preventDefault();
                alert('Please select a parent menu.');
                return false;
            }
        }
        
        return true;
    });
});