/**
 * User Management JavaScript
 */
document.addEventListener('DOMContentLoaded', function() {
    // Block user button click
    document.querySelectorAll('.block-user').forEach(function(button) {
        button.addEventListener('click', function() {
            const id = this.getAttribute('data-id');
            const name = this.getAttribute('data-name');
            
            document.getElementById('block-user-id').value = id;
            document.getElementById('block-user-name').textContent = name;
        });
    });
    
    // Unblock user button click
    document.querySelectorAll('.unblock-user').forEach(function(button) {
        button.addEventListener('click', function() {
            const id = this.getAttribute('data-id');
            const name = this.getAttribute('data-name');
            
            document.getElementById('unblock-user-id').value = id;
            document.getElementById('unblock-user-name').textContent = name;
        });
    });
    
    // Message user button click
    document.querySelectorAll('.message-user').forEach(function(button) {
        button.addEventListener('click', function() {
            const id = this.getAttribute('data-id');
            const name = this.getAttribute('data-name');
            
            document.getElementById('message-user-id').value = id;
            document.getElementById('message-recipient').value = name;
            document.getElementById('message').value = ''; // Clear previous message
        });
    });
    
    // Form validation for message form
    const messageForm = document.querySelector('#messageUserModal form');
    if (messageForm) {
        messageForm.addEventListener('submit', function(event) {
            const message = document.getElementById('message').value.trim();
            
            if (!message) {
                event.preventDefault();
                alert('Please enter a message.');
            }
        });
    }
});