<?php
/**
 * Main configuration file for Telegram Bot with Admin Panel
 */

// Error reporting settings
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/../logs/error.log');

// Bot configuration
define('BOT_TOKEN', '8340358963:AAHrc5kVhrnOdJiKH0TkJwATrWJdkbFBN-E'); // Bot token
define('BOT_USERNAME', 'tatkal_father_bot'); // Bot username without @
define('WEBHOOK_URL', 'https://forexbot.co.in/new_bot/webhook.php'); // Webhook URL

// Admin configuration
define('ADMIN_IDS', [123456789]); // Array of Telegram user IDs who are admins - update with your actual Telegram ID
define('ADMIN_PASSWORD', 'admin123'); // Default admin password - change this to a secure password

// Database configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'mbofzzfa_new_bot_db'); // Changed to match error message
define('DB_USER', 'mbofzzfa_new_bot_user'); // Changed to root user for local development
define('DB_PASS', 'OClBcJ0KcZE4[b?B'); // Empty password for local development
define('DB_CHARSET', 'utf8mb4');

// Session configuration
define('SESSION_LIFETIME', 3600); // Session lifetime in seconds (1 hour)

// Path configuration
define('BASE_PATH', dirname(__DIR__));
define('ADMIN_PATH', BASE_PATH . '/admin');
define('INCLUDES_PATH', BASE_PATH . '/includes');
define('CLASSES_PATH', BASE_PATH . '/classes');
define('LOGS_PATH', BASE_PATH . '/logs');
define('ASSETS_PATH', BASE_PATH . '/assets');

// URL configuration
define('BASE_URL', 'https://forexbot.co.in/new_bot'); // Base URL path
define('ADMIN_URL', 'https://forexbot.co.in/new_bot/admin'); // Admin URL path
define('ASSETS_URL', BASE_URL . '/assets'); // Assets URL path

// Message configuration
define('MESSAGES', [
    'welcome' => 'Welcome to our Telegram bot! Use the menu below to navigate.',
    'menu_prompt' => 'Please select an option from the menu:',
    'error' => 'Sorry, an error occurred. Please try again later.',
    'not_found' => 'Sorry, I couldn\'t find what you were looking for.',
    'blocked' => 'You have been blocked from using this bot.',
]);

/**
 * Helper Functions
 */

// Check if a user is an admin
function isAdmin($userId) {
    return in_array($userId, ADMIN_IDS);
}

// Log errors to file
function logError($message, $context = []) {
    $logMessage = date('[Y-m-d H:i:s]') . ' ERROR: ' . $message;
    if (!empty($context)) {
        $logMessage .= ' - Context: ' . json_encode($context);
    }
    error_log($logMessage);
}

// Log activity
function logActivity($type, $userId, $adminId, $action, $description = '', $ipAddress = '') {
    global $db;
    
    if (!isset($db) || !$db) {
        return false;
    }
    
    try {
        $stmt = $db->prepare("INSERT INTO activity_logs (log_type, user_id, admin_id, action, description, ip_address) 
                            VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->execute([$type, $userId, $adminId, $action, $description, $ipAddress]);
        return true;
    } catch (Exception $e) {
        logError('Failed to log activity: ' . $e->getMessage());
        return false;
    }
}