<?php
/**
 * Configuration Sample File
 * 
 * Copy this file to config.php and update the values according to your setup.
 */

// Error reporting (set to 0 in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Bot Configuration
$config = [
    // Bot settings
    'bot' => [
        'token' => 'YOUR_BOT_TOKEN_HERE', // Get from BotFather
        'username' => 'YourBotUsername', // Without the @ symbol
        'webhook_url' => 'https://yourdomain.com/path/to/webhook.php', // Full URL to webhook.php
        'debug' => false, // Set to true to enable debug logging
    ],
    
    // Admin configuration
    'admin' => [
        'ids' => [123456789], // Array of admin Telegram user IDs
        'password' => 'change_this_password', // Admin panel password
        'session_lifetime' => 86400, // Session lifetime in seconds (24 hours)
    ],
    
    // Database configuration
    'db' => [
        'host' => 'localhost',
        'name' => 'telegram_bot',
        'user' => 'db_username',
        'pass' => 'db_password',
        'charset' => 'utf8mb4',
    ],
    
    // Path configuration
    'paths' => [
        'base' => __DIR__ . '/../', // Base path of the application
        'admin' => __DIR__ . '/../admin/', // Admin panel path
        'includes' => __DIR__ . '/../includes/', // Includes path
        'classes' => __DIR__ . '/../classes/', // Classes path
        'logs' => __DIR__ . '/../logs/', // Logs path
        'assets' => __DIR__ . '/../admin/assets/', // Assets path
    ],
    
    // URL configuration
    'urls' => [
        'base' => 'https://yourdomain.com/path/to/bot/', // Base URL of the application
        'admin' => 'https://yourdomain.com/path/to/bot/admin/', // Admin panel URL
        'assets' => 'https://yourdomain.com/path/to/bot/admin/assets/', // Assets URL
    ],
    
    // Message templates
    'messages' => [
        'welcome' => "Welcome to our bot! Use the menu below to navigate.",
        'help' => "This bot allows you to access various information and services. Use the menu buttons to navigate.",
        'unknown_command' => "Sorry, I don't understand that command. Please use the menu below.",
        'error' => "An error occurred. Please try again later.",
        'blocked' => "You have been blocked from using this bot. Please contact the administrator if you believe this is an error.",
    ],
    
    // Logging configuration
    'logging' => [
        'enabled' => true,
        'level' => 'info', // debug, info, warning, error
        'max_file_size' => 10 * 1024 * 1024, // 10 MB
        'max_files' => 5, // Number of log files to keep
    ],
    
    // Security settings
    'security' => [
        'csrf_protection' => true, // Enable CSRF protection for forms
        'session_regenerate' => true, // Regenerate session ID on login
        'password_algo' => PASSWORD_BCRYPT, // Password hashing algorithm
        'password_options' => ['cost' => 12], // Password hashing options
    ],
    
    // Performance settings
    'performance' => [
        'cache_enabled' => true, // Enable caching
        'cache_lifetime' => 3600, // Cache lifetime in seconds (1 hour)
    ],
];

// Define constants
define('DEBUG_MODE', $config['bot']['debug']);
define('BASE_PATH', $config['paths']['base']);
define('ADMIN_PATH', $config['paths']['admin']);
define('INCLUDES_PATH', $config['paths']['includes']);
define('CLASSES_PATH', $config['paths']['classes']);
define('LOGS_PATH', $config['paths']['logs']);
define('ASSETS_PATH', $config['paths']['assets']);

define('BASE_URL', $config['urls']['base']);
define('ADMIN_URL', $config['urls']['admin']);
define('ASSETS_URL', $config['urls']['assets']);

// Return the configuration
return $config;