<?php
/**
 * Database Initialization Script
 * 
 * This script initializes the database using the schema.sql file.
 * It should be run once during initial setup.
 */

// Include configuration
require_once '../config/config.php';

// Function to execute SQL from a file
function executeSQLFile($filename, $dbConnection) {
    echo "Executing SQL file: {$filename}\n";
    
    // Read the SQL file
    $sql = file_get_contents($filename);
    if ($sql === false) {
        die("Error reading SQL file: {$filename}\n");
    }
    
    // Split SQL by semicolon to get individual queries
    $queries = explode(';', $sql);
    
    // Execute each query
    $count = 0;
    foreach ($queries as $query) {
        $query = trim($query);
        if (!empty($query)) {
            try {
                $stmt = $dbConnection->prepare($query);
                $stmt->execute();
                $count++;
            } catch (PDOException $e) {
                echo "Error executing query: {$query}\n";
                echo "Error message: " . $e->getMessage() . "\n";
            }
        }
    }
    
    echo "Successfully executed {$count} queries\n";
    return $count;
}

// Main execution
try {
    // Create database connection
    $dsn = "mysql:host=" . DB_HOST;
    $options = [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false,
    ];
    
    echo "Connecting to database server...\n";
    $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
    
    // Create database if it doesn't exist
    echo "Creating database if it doesn't exist...\n";
    $stmt = $pdo->prepare("CREATE DATABASE IF NOT EXISTS " . DB_NAME);
    $stmt->execute();
    
    // Select the database
    echo "Selecting database...\n";
    $pdo->exec("USE " . DB_NAME);
    
    // Execute the SQL file
    $sqlFile = __DIR__ . '/schema.sql';
    $queriesExecuted = executeSQLFile($sqlFile, $pdo);
    
    echo "\nDatabase initialization completed successfully!\n";
    echo "Total queries executed: {$queriesExecuted}\n";
    
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage() . "\n");
}

echo "\nYou can now use the Telegram bot with admin panel.\n";
echo "Default admin credentials:\n";
echo "Username: admin\n";
echo "Password: admin123\n";