@echo off
setlocal enabledelayedexpansion

REM Deployment script for Telegram Bot with Admin Panel (Windows version)
REM This script helps with deploying the bot on Windows servers

REM Display help message
:show_help
if "%1"=="" (
    echo Telegram Bot Deployment Script for Windows
    echo Usage: deploy.bat [options]
    echo.
    echo Options:
    echo   /h, /help       Show this help message
    echo   /i, /init       Initialize the project (create config, set permissions)
    echo   /d, /database   Initialize the database
    echo   /w, /webhook    Set up the webhook
    echo   /a, /all        Perform all initialization steps
    echo   /u, /update     Update an existing installation
    exit /b 0
)

REM Process command line arguments
:process_args
if "%1"=="/h" goto :show_help
if "%1"=="/help" goto :show_help
if "%1"=="/i" goto :init_project
if "%1"=="/init" goto :init_project
if "%1"=="/d" goto :init_database
if "%1"=="/database" goto :init_database
if "%1"=="/w" goto :setup_webhook
if "%1"=="/webhook" goto :setup_webhook
if "%1"=="/a" goto :do_all
if "%1"=="/all" goto :do_all
if "%1"=="/u" goto :update_installation
if "%1"=="/update" goto :update_installation

echo Unknown option: %1
goto :show_help

REM Initialize project
:init_project
echo Initializing project...

REM Create config file if it doesn't exist
if not exist "config\config.php" (
    echo Creating config file...
    copy "config\config.sample.php" "config\config.php"
    echo Please edit config\config.php with your settings
) else (
    echo Config file already exists
)

REM Create logs directory if it doesn't exist
if not exist "logs" (
    echo Creating logs directory...
    mkdir logs
)

echo Project initialized successfully

if "%1"=="/i" exit /b 0
if "%1"=="/init" exit /b 0
shift
goto :process_args

REM Initialize database
:init_database
echo Initializing database...

REM Check if config file exists
if not exist "config\config.php" (
    echo Error: Config file not found. Run with /init first.
    exit /b 1
)

REM Run database initialization script
php database/init_db.php

echo Database initialization completed

if "%1"=="/d" exit /b 0
if "%1"=="/database" exit /b 0
shift
goto :process_args

REM Set up webhook
:setup_webhook
echo Setting up webhook...

REM Check if config file exists
if not exist "config\config.php" (
    echo Error: Config file not found. Run with /init first.
    exit /b 1
)

REM Create a temporary PHP script to extract webhook URL and bot token
echo ^<?php > temp_extract.php
echo $config = require 'config/config.php'; >> temp_extract.php
echo echo $config['bot']['webhook_url'] . "\n" . $config['bot']['token']; >> temp_extract.php

REM Run the script and capture output
for /f "tokens=1,2" %%a in ('php temp_extract.php') do (
    set WEBHOOK_URL=%%a
    set BOT_TOKEN=%%b
)

REM Delete temporary script
del temp_extract.php

if "!WEBHOOK_URL!"=="" (
    echo Error: Webhook URL not found in config file.
    exit /b 1
)

if "!BOT_TOKEN!"=="" (
    echo Error: Bot Token not found in config file.
    exit /b 1
)

REM Set webhook using Telegram API
echo Setting webhook to: !WEBHOOK_URL!
curl -s "https://api.telegram.org/bot!BOT_TOKEN!/setWebhook?url=!WEBHOOK_URL!"
echo.

echo Webhook setup completed

if "%1"=="/w" exit /b 0
if "%1"=="/webhook" exit /b 0
shift
goto :process_args

REM Update existing installation
:update_installation
echo Updating installation...

REM Pull latest changes if git is used
if exist ".git" (
    echo Pulling latest changes from git...
    git pull
) else (
    echo Not a git repository. Manual update required.
)

echo Update completed

if "%1"=="/u" exit /b 0
if "%1"=="/update" exit /b 0
shift
goto :process_args

REM Perform all initialization steps
:do_all
call :init_project
call :init_database
call :setup_webhook
exit /b 0