<?php
/**
 * Fix Admin Tables Script
 * 
 * This script checks and creates missing admin tables in the database.
 */

// Include configuration
require_once __DIR__ . '/config/config.php';

echo "=== Admin Tables Fix ===\n\n";

try {
    // Create database connection
    $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME;
    $options = [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false,
    ];
    
    echo "Connecting to database...\n";
    $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
    echo "Connected successfully.\n\n";
    
    // Check and create admin_users table
    echo "Checking admin_users table...\n";
    $stmt = $pdo->query("SHOW TABLES LIKE 'admin_users'");
    if ($stmt->rowCount() == 0) {
        echo "Creating admin_users table...\n";
        $sql = "CREATE TABLE IF NOT EXISTS admin_users (
            id INT AUTO_INCREMENT PRIMARY KEY,
            username VARCHAR(50) NOT NULL UNIQUE,
            password VARCHAR(255) NOT NULL,
            email VARCHAR(255),
            last_login TIMESTAMP NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";
        $pdo->exec($sql);
        
        // Insert default admin user (username: admin, password: admin123)
        echo "Adding default admin user...\n";
        $sql = "INSERT INTO admin_users (username, password, email) VALUES 
            ('admin', '$2y$10$8WxSGxQJ.qXu9/UcyHoWnOxDVL4l2ksNs/HEIccXYRZuRjHGW9AFu', 'admin@example.com')";
        $pdo->exec($sql);
        echo "Default admin user created.\n";
    } else {
        echo "admin_users table already exists.\n";
    }
    
    // Check and create admin_sessions table
    echo "\nChecking admin_sessions table...\n";
    $stmt = $pdo->query("SHOW TABLES LIKE 'admin_sessions'");
    if ($stmt->rowCount() == 0) {
        echo "Creating admin_sessions table...\n";
        $sql = "CREATE TABLE IF NOT EXISTS admin_sessions (
            id INT AUTO_INCREMENT PRIMARY KEY,
            admin_id INT NOT NULL,
            session_token VARCHAR(255) NOT NULL,
            ip_address VARCHAR(45),
            user_agent TEXT,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            expires_at TIMESTAMP NOT NULL,
            FOREIGN KEY (admin_id) REFERENCES admin_users(id) ON DELETE CASCADE
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";
        $pdo->exec($sql);
        echo "admin_sessions table created.\n";
    } else {
        echo "admin_sessions table already exists.\n";
    }
    
    // Check and create settings table
    echo "\nChecking settings table...\n";
    $stmt = $pdo->query("SHOW TABLES LIKE 'settings'");
    if ($stmt->rowCount() == 0) {
        echo "Creating settings table...\n";
        $sql = "CREATE TABLE IF NOT EXISTS settings (
            id INT AUTO_INCREMENT PRIMARY KEY,
            setting_key VARCHAR(255) NOT NULL UNIQUE,
            setting_value TEXT,
            setting_description TEXT,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";
        $pdo->exec($sql);
        
        // Insert default settings
        echo "Adding default settings...\n";
        $sql = "INSERT INTO settings (setting_key, setting_value, setting_description) VALUES
            ('bot_name', 'My Telegram Bot', 'Name of the Telegram bot'),
            ('welcome_message', 'Welcome to our Telegram bot! Use the menu below to navigate.', 'Welcome message sent to new users'),
            ('session_timeout', '3600', 'Admin session timeout in seconds (default: 1 hour)')";
        $pdo->exec($sql);
        echo "Default settings created.\n";
    } else {
        echo "settings table already exists.\n";
    }
    
    // Check and create activity_logs table
    echo "\nChecking activity_logs table...\n";
    $stmt = $pdo->query("SHOW TABLES LIKE 'activity_logs'");
    if ($stmt->rowCount() == 0) {
        echo "Creating activity_logs table...\n";
        $sql = "CREATE TABLE IF NOT EXISTS activity_logs (
            id INT AUTO_INCREMENT PRIMARY KEY,
            log_type ENUM('user', 'admin', 'system') NOT NULL,
            user_id BIGINT,
            admin_id INT,
            action VARCHAR(255) NOT NULL,
            description TEXT,
            ip_address VARCHAR(45),
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            INDEX (log_type),
            INDEX (user_id),
            INDEX (admin_id)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";
        $pdo->exec($sql);
        echo "activity_logs table created.\n";
    } else {
        echo "activity_logs table already exists.\n";
    }
    
    echo "\nAll admin tables have been checked and created if needed.\n";
    echo "You can now access the admin panel at: " . ADMIN_PANEL_URL . "\n";
    echo "Default admin credentials:\n";
    echo "Username: admin\n";
    echo "Password: admin123\n";
    
} catch (PDOException $e) {
    echo "❌ Database error: " . $e->getMessage() . "\n";
}

echo "\n=== Fix Complete ===\n";