-- SQL commands to grant proper permissions to the database user
-- Replace placeholders with your actual values if needed

-- Create the database if it doesn't exist
CREATE DATABASE IF NOT EXISTS mbofzzfa_new_bot_db;

-- Grant all privileges on the database to the user
GRANT ALL PRIVILEGES ON mbofzzfa_new_bot_db.* TO 'mbofzzfa_new_bot_user'@'localhost';

-- If you need to create the user first (if it doesn't exist)
-- CREATE USER 'mbofzzfa_new_bot_user'@'localhost' IDENTIFIED BY 'OClBcJ0KcZE4[b?B';
-- GRANT ALL PRIVILEGES ON mbofzzfa_new_bot_db.* TO 'mbofzzfa_new_bot_user'@'localhost';

-- If you need to grant access from any host, not just localhost
-- GRANT ALL PRIVILEGES ON mbofzzfa_new_bot_db.* TO 'mbofzzfa_new_bot_user'@'%';

-- Apply the privileges
FLUSH PRIVILEGES;

-- Verify the user has the correct privileges (run as a separate query)
-- SHOW GRANTS FOR 'mbofzzfa_new_bot_user'@'localhost';