<?php
/**
 * Database connection handler
 */

// Include configuration file if not already included
if (!defined('DB_HOST')) {
    require_once dirname(__DIR__) . '/config/config.php';
}

/**
 * Get database connection
 * @return PDO Database connection object
 */
function getDbConnection() {
    static $db = null;
    
    if ($db === null) {
        try {
            // Create PDO connection
            $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
            $options = [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false,
            ];
            
            $db = new PDO($dsn, DB_USER, DB_PASS, $options);
            
        } catch (PDOException $e) {
            logError("Database connection failed: " . $e->getMessage());
            die("Database connection failed. Please check your configuration.");
        }
    }
    
    return $db;
}

// Get database connection
$db = getDbConnection();