<?php
/**
 * Set Bot Commands Script
 * 
 * This script sets the commands for your Telegram bot.
 * These commands will be shown in the Telegram interface when users type /.
 */

// Include configuration
require_once __DIR__ . '/config/config.php';

echo "=== Setting Commands for Telegram Bot ===\n\n";

// Validate configuration
if (empty(BOT_TOKEN)) {
    die("Error: Bot token is not configured. Please update your config.php file.\n");
}

// Define commands
$commands = [
    [
        'command' => 'start',
        'description' => 'Start the bot'
    ],
    [
        'command' => 'help',
        'description' => 'Show help information'
    ],
    [
        'command' => 'menu',
        'description' => 'Show main menu'
    ],
    [
        'command' => 'settings',
        'description' => 'Show user settings'
    ],
    [
        'command' => 'about',
        'description' => 'About this bot'
    ],
    [
        'command' => 'contact',
        'description' => 'Contact information'
    ]
];

// Convert commands to JSON
$jsonCommands = json_encode($commands);

// Set commands
$url = "https://api.telegram.org/bot" . BOT_TOKEN . "/setMyCommands";

if (function_exists('curl_version')) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, [
        'commands' => $jsonCommands
    ]);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $response = curl_exec($ch);
    curl_close($ch);
} else {
    // Fallback to file_get_contents if curl is not available
    $options = [
        'http' => [
            'method' => 'POST',
            'header' => 'Content-Type: application/x-www-form-urlencoded',
            'content' => http_build_query([
                'commands' => $jsonCommands
            ])
        ]
    ];
    $context = stream_context_create($options);
    $response = file_get_contents($url, false, $context);
}

$result = json_decode($response, true);

if (isset($result['ok']) && $result['ok']) {
    echo "✓ Commands set successfully!\n";
    echo "Description: {$result['description']}\n";
    
    echo "\nThe following commands have been set:\n";
    foreach ($commands as $command) {
        echo "- /{$command['command']} - {$command['description']}\n";
    }
} else {
    echo "✗ Failed to set commands!\n";
    echo "Error: " . (isset($result['description']) ? $result['description'] : "Unknown error") . "\n";
}

echo "\n=== Done ===\n";