<?php
/**
 * Set Webhook Script
 * 
 * This script sets the webhook URL for your Telegram bot.
 * Run this script once to configure your bot to receive updates via webhook.
 */

// Include configuration
require_once __DIR__ . '/config/config.php';

echo "=== Setting Webhook for Telegram Bot ===\n\n";

// Validate configuration
if (empty(BOT_TOKEN)) {
    die("Error: Bot token is not configured. Please update your config.php file.\n");
}

if (empty(WEBHOOK_URL)) {
    die("Error: Webhook URL is not configured. Please update your config.php file.\n");
}

// Set webhook URL
$url = "https://api.telegram.org/bot" . BOT_TOKEN . "/setWebhook?url=" . urlencode(WEBHOOK_URL);

echo "Setting webhook to: " . WEBHOOK_URL . "\n";

// Make API request
if (function_exists('curl_version')) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $response = curl_exec($ch);
    curl_close($ch);
    
    $result = json_decode($response, true);
    
    if (isset($result['ok']) && $result['ok']) {
        echo "✓ Webhook set successfully!\n";
        echo "Description: {$result['description']}\n";
    } else {
        echo "✗ Failed to set webhook!\n";
        echo "Error: " . (isset($result['description']) ? $result['description'] : "Unknown error") . "\n";
    }
} else {
    // Fallback to file_get_contents if curl is not available
    $response = file_get_contents($url);
    $result = json_decode($response, true);
    
    if (isset($result['ok']) && $result['ok']) {
        echo "✓ Webhook set successfully!\n";
        echo "Description: {$result['description']}\n";
    } else {
        echo "✗ Failed to set webhook!\n";
        echo "Error: " . (isset($result['description']) ? $result['description'] : "Unknown error") . "\n";
    }
}

// Get webhook info
echo "\n=== Current Webhook Information ===\n";

$url = "https://api.telegram.org/bot" . BOT_TOKEN . "/getWebhookInfo";

if (function_exists('curl_version')) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $response = curl_exec($ch);
    curl_close($ch);
} else {
    $response = file_get_contents($url);
}

$result = json_decode($response, true);

if (isset($result['ok']) && $result['ok']) {
    echo "URL: {$result['result']['url']}\n";
    echo "Has custom certificate: " . ($result['result']['has_custom_certificate'] ? "Yes" : "No") . "\n";
    echo "Pending update count: {$result['result']['pending_update_count']}\n";
    
    if (isset($result['result']['last_error_date'])) {
        $date = date('Y-m-d H:i:s', $result['result']['last_error_date']);
        echo "Last error date: {$date}\n";
        echo "Last error message: {$result['result']['last_error_message']}\n";
    }
    
    if (isset($result['result']['max_connections'])) {
        echo "Max connections: {$result['result']['max_connections']}\n";
    }
    
    if (isset($result['result']['allowed_updates']) && !empty($result['result']['allowed_updates'])) {
        echo "Allowed updates: " . implode(", ", $result['result']['allowed_updates']) . "\n";
    }
} else {
    echo "Failed to get webhook information.\n";
}

echo "\n=== Done ===\n";