<?php
/**
 * Setup Bot Script
 * 
 * This script runs all the necessary setup steps for your Telegram bot in sequence.
 * It will verify configuration, initialize the database, set webhook, and configure commands.
 */

// Include configuration
require_once __DIR__ . '/config/config.php';

echo "=== Telegram Bot Setup ===\n\n";

// Step 1: Verify Configuration
echo "Step 1: Verifying Configuration...\n";
ob_start();
include __DIR__ . '/verify_config.php';
$verify_output = ob_get_clean();
echo "Configuration verification complete.\n";
echo "Result: " . (strpos($verify_output, "All configurations are valid") !== false ? "✓ Success" : "✗ Issues found") . "\n\n";

// Step 2: Initialize Database
echo "Step 2: Initializing Database...\n";
ob_start();
include __DIR__ . '/database/init_db.php';
$db_output = ob_get_clean();
echo "Database initialization complete.\n";
echo "Result: " . (strpos($db_output, "Error") === false ? "✓ Success" : "✗ Issues found") . "\n\n";

// Step 3: Set Webhook
echo "Step 3: Setting Webhook...\n";
ob_start();
include __DIR__ . '/set_webhook.php';
$webhook_output = ob_get_clean();
echo "Webhook setup complete.\n";
echo "Result: " . (strpos($webhook_output, "Webhook set successfully") !== false ? "✓ Success" : "✗ Issues found") . "\n\n";

// Step 4: Set Commands
echo "Step 4: Setting Bot Commands...\n";
ob_start();
include __DIR__ . '/set_commands.php';
$commands_output = ob_get_clean();
echo "Commands setup complete.\n";
echo "Result: " . (strpos($commands_output, "Commands set successfully") !== false ? "✓ Success" : "✗ Issues found") . "\n\n";

// Step 5: Check Bot Status
echo "Step 5: Checking Bot Status...\n";
ob_start();
include __DIR__ . '/check_bot.php';
$status_output = ob_get_clean();
echo "Bot status check complete.\n";
echo "Result: " . (strpos($status_output, "Bot is working correctly") !== false ? "✓ Success" : "✗ Issues found") . "\n\n";

// Summary
echo "=== Setup Summary ===\n";
echo "Configuration: " . (strpos($verify_output, "All configurations are valid") !== false ? "✓ Valid" : "✗ Invalid") . "\n";
echo "Database: " . (strpos($db_output, "Error") === false ? "✓ Initialized" : "✗ Issues found") . "\n";
echo "Webhook: " . (strpos($webhook_output, "Webhook set successfully") !== false ? "✓ Set" : "✗ Not set") . "\n";
echo "Commands: " . (strpos($commands_output, "Commands set successfully") !== false ? "✓ Configured" : "✗ Not configured") . "\n";
echo "Bot Status: " . (strpos($status_output, "Bot is working correctly") !== false ? "✓ Working" : "✗ Issues found") . "\n\n";

echo "Next Steps:\n";
echo "1. Access the admin panel at: " . ADMIN_PANEL_URL . "\n";
echo "2. Update your admin Telegram ID in config.php\n";
echo "3. Change the default admin password\n\n";

echo "For more information, please refer to QUICK_START.md\n";
echo "=== Setup Complete ===\n";