<?php
// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Basic PHP info
echo "<h1>PHP Test Script</h1>";
echo "<p>PHP Version: " . phpversion() . "</p>";

// Check if required extensions are loaded
$requiredExtensions = ['pdo', 'pdo_mysql', 'mbstring', 'json', 'session'];
echo "<h2>Required Extensions</h2>";
echo "<ul>";
foreach ($requiredExtensions as $extension) {
    if (extension_loaded($extension)) {
        echo "<li style='color:green'>✓ {$extension} is loaded</li>";
    } else {
        echo "<li style='color:red'>✗ {$extension} is NOT loaded</li>";
    }
}
echo "</ul>";

// Check if config file exists and is readable
$configFile = __DIR__ . '/config/config.php';
echo "<h2>Configuration Check</h2>";
if (file_exists($configFile) && is_readable($configFile)) {
    echo "<p style='color:green'>✓ Config file exists and is readable</p>";
    
    // Include config file to check if constants are defined
    include_once $configFile;
    
    // Check database constants
    $dbConstants = ['DB_HOST', 'DB_NAME', 'DB_USER', 'DB_PASS', 'DB_CHARSET'];
    echo "<h3>Database Constants</h3>";
    echo "<ul>";
    foreach ($dbConstants as $constant) {
        if (defined($constant)) {
            echo "<li style='color:green'>✓ {$constant} is defined</li>";
        } else {
            echo "<li style='color:red'>✗ {$constant} is NOT defined</li>";
        }
    }
    echo "</ul>";
    
    // Check path constants
    $pathConstants = ['BASE_PATH', 'ADMIN_PATH', 'INCLUDES_PATH', 'CLASSES_PATH', 'LOGS_PATH'];
    echo "<h3>Path Constants</h3>";
    echo "<ul>";
    foreach ($pathConstants as $constant) {
        if (defined($constant)) {
            echo "<li style='color:green'>✓ {$constant} is defined</li>";
            
            // Check if directory exists and is writable
            if (is_dir(constant($constant))) {
                echo " (Directory exists";
                if (is_writable(constant($constant))) {
                    echo " and is writable)";
                } else {
                    echo " but is NOT writable)";
                }
            } else {
                echo " (Directory does NOT exist)";
            }
        } else {
            echo "<li style='color:red'>✗ {$constant} is NOT defined</li>";
        }
    }
    echo "</ul>";
} else {
    echo "<p style='color:red'>✗ Config file does not exist or is not readable</p>";
}

// Check database connection
echo "<h2>Database Connection Test</h2>";
if (defined('DB_HOST') && defined('DB_NAME') && defined('DB_USER') && defined('DB_PASS')) {
    try {
        $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
        $options = [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
        ];
        
        $db = new PDO($dsn, DB_USER, DB_PASS, $options);
        echo "<p style='color:green'>✓ Successfully connected to database</p>";
        
        // Check if required tables exist
        $requiredTables = ['admin_users', 'admin_sessions', 'settings', 'activity_logs'];
        echo "<h3>Required Tables</h3>";
        echo "<ul>";
        foreach ($requiredTables as $table) {
            $stmt = $db->query("SHOW TABLES LIKE '{$table}'")->fetchColumn();
            if ($stmt) {
                echo "<li style='color:green'>✓ {$table} table exists</li>";
            } else {
                echo "<li style='color:red'>✗ {$table} table does NOT exist</li>";
            }
        }
        echo "</ul>";
    } catch (PDOException $e) {
        echo "<p style='color:red'>✗ Database connection failed: " . $e->getMessage() . "</p>";
    }
} else {
    echo "<p style='color:red'>✗ Database constants are not defined</p>";
}

// Check logs directory
$logsDir = __DIR__ . '/logs';
echo "<h2>Logs Directory Check</h2>";
if (is_dir($logsDir)) {
    echo "<p style='color:green'>✓ Logs directory exists</p>";
    if (is_writable($logsDir)) {
        echo "<p style='color:green'>✓ Logs directory is writable</p>";
    } else {
        echo "<p style='color:red'>✗ Logs directory is NOT writable</p>";
    }
} else {
    echo "<p style='color:red'>✗ Logs directory does NOT exist</p>";
}

// Check if logError function exists
echo "<h2>Function Check</h2>";
if (function_exists('logError')) {
    echo "<p style='color:green'>✓ logError function exists</p>";
} else {
    echo "<p style='color:red'>✗ logError function does NOT exist</p>";
}

// Check session configuration
echo "<h2>Session Configuration</h2>";
echo "<p>Session Save Path: " . ini_get('session.save_path') . "</p>";
if (defined('SESSION_LIFETIME')) {
    echo "<p style='color:green'>✓ SESSION_LIFETIME constant is defined: " . SESSION_LIFETIME . " seconds</p>";
} else {
    echo "<p style='color:red'>✗ SESSION_LIFETIME constant is NOT defined</p>";
}

// Check .htaccess file in admin directory
$htaccessFile = __DIR__ . '/admin/.htaccess';
echo "<h2>.htaccess Check</h2>";
if (file_exists($htaccessFile) && is_readable($htaccessFile)) {
    echo "<p style='color:green'>✓ .htaccess file exists in admin directory</p>";
    
    // Check .htaccess content
    $htaccessContent = file_get_contents($htaccessFile);
    if (strpos($htaccessContent, 'ErrorDocument 500') !== false) {
        echo "<p style='color:green'>✓ .htaccess has 500 error handler configured</p>";
    } else {
        echo "<p style='color:red'>✗ .htaccess does NOT have 500 error handler configured</p>";
    }
} else {
    echo "<p style='color:red'>✗ .htaccess file does NOT exist or is NOT readable in admin directory</p>";
}

// Check error.php file in admin directory
$errorFile = __DIR__ . '/admin/error.php';
if (file_exists($errorFile) && is_readable($errorFile)) {
    echo "<p style='color:green'>✓ error.php file exists in admin directory</p>";
} else {
    echo "<p style='color:red'>✗ error.php file does NOT exist or is NOT readable in admin directory</p>";
}

echo "<h2>Server Information</h2>";
echo "<pre>";
print_r($_SERVER);
echo "</pre>";